/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.graph;

import emulator.shell.GUI.graph.BitGraphLine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JPanel;

public class BitGraph
extends JPanel {
    private static final int PREFERRED_WIDTH = 400;
    private static final int PREFERRED_HEIGHT = 600;
    private static final int BORDER_GAP_LEFT = 40;
    private static final int BORDER_GAP_RIGHT = 30;
    private static final int BORDER_GAP_TOP = 20;
    private static final int BORDER_GAP_BOTTOM = 50;
    private static final int LINE_GAP = 10;
    private BitGraphLine[] graphLines;
    private long tickBegin = 0L;
    private long tickEnd = 0L;
    private int scalesSteps = 1;

    public BitGraph(int lineCount) {
        this.graphLines = new BitGraphLine[lineCount];
        int i = 0;
        while (i < this.graphLines.length) {
            this.graphLines[i] = new BitGraphLine();
            ++i;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fontMetrics = this.getFontMetrics(g2.getFont());
        int maxIndex = 0;
        int i = 0;
        while (i < this.graphLines.length) {
            if (this.graphLines[i].getPositionIndex() > maxIndex) {
                maxIndex = this.graphLines[i].getPositionIndex();
            }
            ++i;
        }
        int lineCount = maxIndex + 1;
        ArrayList labelLineStack = new ArrayList(lineCount);
        int i2 = 0;
        while (i2 < lineCount) {
            labelLineStack.add(new LinkedList());
            ++i2;
        }
        i2 = 0;
        while (i2 < this.graphLines.length) {
            ((LinkedList)labelLineStack.get(this.graphLines[i2].getPositionIndex())).add(this.graphLines[i2]);
            ++i2;
        }
        int width = this.getWidth() - 40 - 30;
        int height = this.getHeight() - 20 - 50;
        double lineHeight = (double)(height - maxIndex * 10) / (double)lineCount;
        g2.setColor(Color.white);
        g2.fillRect(40, 10, width, height + 20);
        g2.setColor(Color.black);
        g2.drawRect(40, 10, width, height + 20);
        int i3 = 0;
        while (i3 < lineCount) {
            if (((LinkedList)labelLineStack.get(i3)).size() > 0) {
                double y1 = 20.0 + (double)i3 * (lineHeight + 10.0);
                double yd = lineHeight / (double)((LinkedList)labelLineStack.get(i3)).size();
                int j = 0;
                while (j < ((LinkedList)labelLineStack.get(i3)).size()) {
                    g2.setColor(((BitGraphLine)((LinkedList)labelLineStack.get(i3)).get(j)).getColor());
                    g2.drawString(((BitGraphLine)((LinkedList)labelLineStack.get(i3)).get(j)).getLabel(), 5, (int)(y1 + yd * (double)(j + 1)));
                    ++j;
                }
            }
            ++i3;
        }
        this.scalesSteps = width / fontMetrics.stringWidth("000000000");
        if (this.tickEnd > this.tickBegin && this.scalesSteps > 0) {
            if ((long)this.scalesSteps > this.tickEnd - this.tickBegin) {
                this.scalesSteps = (int)(this.tickEnd - this.tickBegin);
            }
            int scalesBaseLine = 20 + height + 20 + fontMetrics.getHeight();
            int i4 = 0;
            while (i4 < this.scalesSteps + 1) {
                String scaleText = "" + (this.tickEnd - (this.tickEnd - this.tickBegin) * (long)(this.scalesSteps - i4) / (long)this.scalesSteps);
                int xm = 40 + width * i4 / this.scalesSteps;
                int textWidth = fontMetrics.stringWidth(scaleText);
                g2.drawString(scaleText, xm - textWidth / 2, scalesBaseLine);
                g2.drawLine(xm, 10, xm, 20 + height + 10);
                ++i4;
            }
        }
        i3 = 0;
        while (i3 < this.graphLines.length) {
            this.graphLines[i3].draw(g2, this.tickBegin, this.tickEnd, 40, 20, 10, width, lineHeight);
            ++i3;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 600);
    }

    public BitGraphLine getGraphLine(int i) {
        return this.graphLines[i];
    }

    public void setRange(long tickBegin, long tickEnd) {
        this.tickBegin = tickBegin;
        this.tickEnd = tickEnd;
    }

    public long getRange() {
        return this.tickEnd - this.tickBegin;
    }

    public int getScalesSteps() {
        return this.scalesSteps;
    }
}

